/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.application.Bitmap;
import netscape.application.Graphics;
import netscape.application.Image;
import netscape.application.Rect;
import netscape.application.TextAttachment;
import netscape.util.ClassInfo;
import netscape.util.Codable;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.Encoder;

public class ImageAttachment
extends TextAttachment
implements Codable {
    private Image image;
    boolean incrementalBitmap;
    int width;
    int height;
    static final String IMAGE_KEY = "image";

    public ImageAttachment() {
        this.image = null;
        this.incrementalBitmap = false;
    }

    public ImageAttachment(Image image) {
        this.image = image;
        this.incrementalBitmap = false;
    }

    ImageAttachment(Bitmap bitmap, int n, int n2) {
        this.image = bitmap;
        this.width = n;
        this.height = n2;
        this.incrementalBitmap = true;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public Image image() {
        return this.image;
    }

    public int width() {
        if (this.incrementalBitmap) {
            return this.width;
        }
        if (this.image != null) {
            return this.image.width();
        }
        return 0;
    }

    public int height() {
        if (this.incrementalBitmap) {
            return this.height;
        }
        if (this.image != null) {
            return this.image.height();
        }
        return 0;
    }

    public void drawInRect(Graphics graphics, Rect rect) {
        if (graphics == null || rect == null) {
            return;
        }
        Rect rect2 = graphics.clipRect();
        if (this.image != null) {
            this.image.drawAt(graphics, rect.x, rect.y);
        }
    }

    public void describeClassInfo(ClassInfo classInfo) {
        super.describeClassInfo(classInfo);
        classInfo.addClass("netscape.application.ImageAttachment", 1);
        classInfo.addField(IMAGE_KEY, (byte)18);
    }

    public void encode(Encoder encoder) throws CodingException {
        super.encode(encoder);
        encoder.encodeObject(IMAGE_KEY, this.image);
    }

    public void decode(Decoder decoder) throws CodingException {
        super.decode(decoder);
        this.image = (Image)decoder.decodeObject(IMAGE_KEY);
    }

    public void finishDecoding() throws CodingException {
        super.finishDecoding();
        this.incrementalBitmap = false;
    }
}

