/*
 * Decompiled with CFR 0.152.
 */
package symantec.tools.debug;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import netscape.debug.DebugManager;
import netscape.debug.Debugger;
import sun.tools.java.ClassFile;
import sun.tools.java.ClassPath;
import sun.tools.java.Identifier;
import sun.tools.java.Package;
import symantec.tools.debug.AgentConstants;
import symantec.tools.debug.AgentOutputStream;
import symantec.tools.debug.BreakpointHandler;
import symantec.tools.debug.BreakpointSet;
import symantec.tools.debug.Field;
import symantec.tools.debug.InvalidPCException;
import symantec.tools.debug.LineNumber;
import symantec.tools.debug.LocalCommStream;
import symantec.tools.debug.MainThread;
import symantec.tools.debug.ResponseStream;
import symantec.tools.debug.StackFrame;
import symantec.tools.debug.SymDbgExprFindContext;
import symantec.tools.debug.SymDbgExprHandler;
import symantec.tools.debug.SymDbgLoadExpr;
import symantec.tools.debug.SymDbgNotify;
import symantec.tools.debug.TeeOutputStream;
import symantec.tools.debug.ThreadList;

public class Agent
implements Runnable,
AgentConstants,
DebugManager {
    static Agent the_Agent = null;
    static int agentPort;
    ServerSocket socket;
    boolean useSockets;
    LocalCommStream localComm1;
    LocalCommStream localComm2;
    DataOutputStream asyncOutputStream;
    PipedInputStream cmdInputPipe;
    PipedOutputStream cmdOutputPipe;
    PipedOutputStream asyncOutputPipe;
    Hashtable objects;
    private BreakpointHandler bkptHandler;
    public static boolean runBegun;
    public static Object runBegunLock;
    public static final int EXPR_LOAD_SUCCESS = 0;
    public static final int EXPR_EVAL_SUCCESS = 0;
    public static final int EXPR_EVAL_INVALID_EXPRESSION = 1;
    public static final int EXPR_EVAL_EXCEPTION = 2;
    private SymDbgExprHandler exprHandler;
    boolean inInterpStep = false;
    private DataOutputStream out;
    private ResponseStream outBuffer;
    private ClassPath sourcePath;
    private Object pipeLock = new Object();
    static boolean verbose;
    private ThreadList lastSuspended;
    static int agentPassword;
    boolean keepRunning = true;
    private int JMP_TARGET_CT;
    private int RET_TARGET_CT = 1;
    private int CALL_TARGET_CT = 2;
    private int TARGET_LIST = 3;
    static Object lock;

    static String toHex(int n) {
        char[] cArray = new char[10];
        int n2 = 0;
        while (n2 < 10) {
            cArray[n2] = 48;
            ++n2;
        }
        cArray[1] = 120;
        int n3 = 9;
        while (n != 0) {
            int n4 = n & 0xF;
            cArray[n3] = (char)(n4 < 10 ? 48 + n4 : 97 + n4 - 10);
            n >>>= 4;
            --n3;
        }
        return new String(cArray);
    }

    private void dumpClasses() throws IOException {
        Agent.message("dumpClasses()");
        Enumeration<Object> enumeration = this.objects.elements();
        Vector vector = new Vector();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            try {
                Object v = enumeration.nextElement();
                if (v == null || !(v instanceof Class)) continue;
                vector.addElement(v);
                ++n;
            }
            catch (Exception exception) {
                Agent.error("dumpClasses() failed: " + exception.toString());
            }
        }
        this.out.writeInt(n);
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.writeObject(enumeration.nextElement());
        }
    }

    private String cookieToString(int n) {
        int n2;
        int n3 = "23456789abcdefghijkmnpqrstuvwxyz".length();
        int n4 = 0;
        StringBuffer stringBuffer = new StringBuffer(32);
        while (n > 0) {
            if (n < n3) {
                stringBuffer.append("23456789abcdefghijkmnpqrstuvwxyz".charAt(n));
                n = 0;
            } else {
                n2 = n % n3;
                n /= n3;
                stringBuffer.append("23456789abcdefghijkmnpqrstuvwxyz".charAt(n2));
            }
            ++n4;
        }
        if (n4 > 0) {
            n2 = stringBuffer.length();
            char[] cArray = new char[n2];
            int n5 = 0;
            while (n2-- > 0) {
                cArray[n2] = stringBuffer.charAt(n5++);
            }
            return String.valueOf(cArray);
        }
        return "0";
    }

    private String makePassword(int n) {
        if (n > 65535) {
            System.err.println("Invalid port number (" + n + ")???");
            return null;
        }
        int n2 = (int)(Math.round(Math.random() * 2048.0) % 2048L);
        int n3 = 0;
        int n4 = 3;
        int n5 = 0;
        while (n5 < 8) {
            int n6 = (n & n4) << n5 + 1;
            int n7 = (n2 & 1 << n5) << n5 * 2;
            n3 |= n6 | n7;
            n4 <<= 2;
            ++n5;
        }
        return this.cookieToString(n3 |= (n2 & 0x700) << 16);
    }

    Agent() {
        this.useSockets = false;
        the_Agent = this;
    }

    Agent(int n) {
        this.useSockets = true;
        the_Agent = this;
        agentPort = n;
        int n2 = 0;
        while (true) {
            try {
                if (n == -1) {
                    int n3 = 1234;
                    String string = "$$VEDbgLocalComm$localhost$channel$$" + n3;
                    this.socket = null;
                    this.localComm1 = new LocalCommStream();
                    this.localComm2 = new LocalCommStream();
                    this.localComm1.create(String.valueOf(string) + "1");
                    this.localComm2.create(String.valueOf(string) + "2");
                    agentPassword = n3;
                    return;
                }
                this.localComm1 = null;
                this.localComm2 = null;
                this.socket = new ServerSocket(n, 10);
                System.out.println("Agent password=" + this.makePassword(this.socket.getLocalPort()));
                return;
            }
            catch (Exception exception) {
                Agent.message("[Waiting to create port]\n");
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
                if (n2 >= 10) {
                    Agent.error("**Failed to create port\n");
                    return;
                }
                ++n2;
                continue;
            }
            break;
        }
    }

    public static void beginRun() {
        Object object = runBegunLock;
        synchronized (object) {
            runBegun = true;
            runBegunLock.notifyAll();
            return;
        }
    }

    static synchronized void connectToAgent(PipedOutputStream pipedOutputStream, PipedInputStream pipedInputStream, PipedInputStream pipedInputStream2) throws IOException {
        if (the_Agent == null || Agent.the_Agent.useSockets) {
            throw new IllegalAccessError();
        }
        Agent.the_Agent.cmdInputPipe = new PipedInputStream(pipedOutputStream);
        Agent.the_Agent.cmdOutputPipe = new PipedOutputStream(pipedInputStream);
        Agent.the_Agent.asyncOutputPipe = new PipedOutputStream(pipedInputStream2);
        Object object = Agent.the_Agent.pipeLock;
        synchronized (object) {
            Agent.the_Agent.pipeLock.notifyAll();
            return;
        }
    }

    static boolean isDebuggable() {
        return the_Agent != null && !Agent.the_Agent.useSockets;
    }

    public void run() {
        PrintStream printStream = null;
        PrintStream printStream2 = null;
        Socket socket = null;
        Socket socket2 = null;
        SecurityManager.enablePrivilege((String)"UniversalPropertyRead");
        String string = System.getProperty("java.class.path");
        if (string == null) {
            string = ".";
        }
        SecurityManager.enablePrivilege((String)"UniversalFileRead");
        this.sourcePath = new ClassPath(string);
        FilterInputStream filterInputStream = null;
        SecurityManager.enablePrivilege((String)"UniversalExecAccess");
        try {
            this.objects = new Hashtable();
            this.bkptHandler = new BreakpointHandler(this);
            this.exprHandler = new SymDbgExprHandler();
            this.bkptHandler.start();
            this.initAgent();
            Class<?> clazz = this.getClass();
            Object object = clazz;
            synchronized (object) {
                clazz.notifyAll();
            }
            Agent.initSystemThreadList();
            while (this.keepRunning) {
                Object object2;
                printStream = System.out;
                printStream2 = System.err;
                if (this.useSockets) {
                    if (this.socket == null) {
                        filterInputStream = new DataInputStream(this.localComm1.getInputStream());
                        this.out = new DataOutputStream(this.localComm1.getOutputStream());
                        this.outBuffer = null;
                        this.asyncOutputStream = new DataOutputStream(this.localComm2.getOutputStream());
                        object = new AgentOutputStream(this.asyncOutputStream);
                    } else {
                        socket = this.socket.accept();
                        Agent.message("cmd socket: " + socket.toString());
                        filterInputStream = new DataInputStream(new BufferedInputStream(socket.getInputStream()));
                        this.outBuffer = new ResponseStream(socket.getOutputStream(), 8192);
                        this.out = new DataOutputStream(this.outBuffer);
                        socket2 = this.socket.accept();
                        this.asyncOutputStream = new DataOutputStream(new BufferedOutputStream(socket2.getOutputStream()));
                        object2 = new AgentOutputStream(this.asyncOutputStream);
                        object = new BufferedOutputStream((OutputStream)object2, 128);
                    }
                } else {
                    try {
                        object2 = Agent.the_Agent.pipeLock;
                        synchronized (object2) {
                            Agent.the_Agent.pipeLock.wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    filterInputStream = new DataInputStream(this.cmdInputPipe);
                    this.outBuffer = new ResponseStream(this.cmdOutputPipe, 8192);
                    this.out = new DataOutputStream(this.outBuffer);
                    this.asyncOutputStream = new DataOutputStream(this.asyncOutputPipe);
                    object = object2 = new AgentOutputStream(this.asyncOutputPipe);
                }
                object2 = new TeeOutputStream((OutputStream)object, printStream);
                TeeOutputStream teeOutputStream = new TeeOutputStream((OutputStream)object, printStream2);
                System.setOut(new PrintStream((OutputStream)object2, true));
                System.setErr(new PrintStream(teeOutputStream, true));
                Agent.debugAgentReady(agentPassword);
                Agent.message("connection accepted");
                this.out.writeInt(71);
                try {
                    this.writeObject(Class.forName("java.lang.Object"));
                    this.writeObject(Class.forName("java.lang.Class"));
                    this.writeObject(Class.forName("java.lang.String"));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    classNotFoundException.printStackTrace();
                }
                this.dumpClasses();
                this.writeObject(Thread.currentThread().getThreadGroup());
                this.out.flush();
                try {
                    int n = filterInputStream.read();
                    while (n != -1 && this.keepRunning) {
                        try {
                            this.handle(n, (DataInputStream)filterInputStream, this.out);
                        }
                        catch (Throwable throwable) {
                            Agent.error(this.exceptionStackTrace(throwable));
                            if (this.outBuffer != null) {
                                this.outBuffer.reset();
                            }
                            this.out.writeInt(-2);
                            this.out.writeUTF(throwable.toString());
                        }
                        this.out.flush();
                        if (this.keepRunning) {
                            n = filterInputStream.read();
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception exception) {
                    Agent.debugAgentReady(0);
                    System.setOut(printStream);
                    System.setErr(printStream2);
                    Agent.error(this.exceptionStackTrace(exception));
                }
                System.setOut(printStream);
                System.setErr(printStream2);
                Agent.message("connection closed");
            }
        }
        catch (ThreadDeath threadDeath) {
            Agent.debugAgentReady(0);
            System.setOut(printStream);
            System.setErr(printStream2);
            Agent.message("ThreadDeath caught.");
        }
        catch (IOException iOException) {
            Agent.debugAgentReady(0);
            System.setOut(printStream);
            System.setErr(printStream2);
            Agent.message("IOException caught.");
        }
        if (socket2 != null) {
            try {
                socket2.close();
            }
            catch (Exception exception) {}
        }
        if (socket != null) {
            try {
                socket.close();
            }
            catch (Exception exception) {}
        }
        if (this.socket == null) {
            try {
                filterInputStream.close();
                this.out.close();
                this.asyncOutputStream.close();
            }
            catch (Exception exception) {}
        }
        this.destroy();
    }

    void destroy() {
        Object object = lock;
        synchronized (object) {
            System.out.println("# Shutting down debug agent.");
            try {
                SecurityManager.enablePrivilege((String)"UniversalSetFactory");
                this.bkptHandler.deleteBreakpoints();
                Agent.destroySystemThreadList();
                SymDbgNotify.notifyInterpDebug(2);
                Debugger.setDebugManager(null);
                agentPassword = 0;
                Agent.debugAgentReady(-1);
                Compiler.enable();
                lock.notify();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return;
        }
    }

    protected void finalize() {
        this.destroy();
    }

    static native void debugAgentReady(int var0);

    public static synchronized native boolean systemThread(Thread var0);

    private static Thread getSystemThread(String string) {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        if (!threadGroup.getName().equals("main")) {
            Agent.error("findThread called from wrong threadgroup");
            return null;
        }
        Thread[] threadArray = new Thread[256];
        int n = threadGroup.enumerate(threadArray, false);
        int n2 = 0;
        while (n2 < n) {
            if (threadArray[n2].getName().equals(string)) {
                return threadArray[n2];
            }
            ++n2;
        }
        return null;
    }

    private static void initSystemThread(String string) {
        Thread thread = Agent.getSystemThread(string);
        if (thread != null) {
            Agent.message("adding " + string + " to system thread list");
            Agent.addSystemThread(thread);
            return;
        }
        Agent.message(String.valueOf(string) + " not found in system threadgroup");
    }

    private static void initSystemThreadList() {
        Agent.initSystemThread("Debugger agent");
        Agent.initSystemThread("Breakpoint handler");
        Agent.initSystemThread("main");
        Agent.initSystemThread("AWT-Windows");
        Agent.initSystemThread("AWT-Callback");
        Agent.initSystemThread("Applet Thread Killer");
        Agent.initSystemThread("ScreenUpdater");
        Agent.initSystemThread("Audio Player");
    }

    private static void destroySystemThread(String string) {
        Thread thread = Agent.getSystemThread(string);
        if (thread != null) {
            Agent.message("removing " + string + " from system thread list");
            Agent.removeSystemThread(thread);
            return;
        }
        Agent.message(String.valueOf(string) + " not found in system threadgroup");
    }

    private static void destroySystemThreadList() {
        Agent.destroySystemThread("Debugger agent");
        Agent.destroySystemThread("Breakpoint handler");
        Agent.destroySystemThread("main");
        Agent.destroySystemThread("AWT-Windows");
        Agent.destroySystemThread("AWT-Callback");
        Agent.destroySystemThread("Applet Thread Killer");
        Agent.destroySystemThread("ScreenUpdater");
        Agent.destroySystemThread("Audio Player");
    }

    public static synchronized native void addSystemThread(Thread var0);

    public static synchronized native void removeSystemThread(Thread var0);

    public void suspendThread(Thread thread) {
        if (!Agent.systemThread(thread)) {
            Agent.message("suspending " + thread.getName());
            try {
                thread.suspend();
                return;
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                Agent.error("suspend failed: " + illegalThreadStateException.getMessage());
                return;
            }
        }
    }

    private void SetTargetBpt(Class clazz, int n, int n2) {
        try {
            this.bkptHandler.addBreakpoint(clazz, n, n2, 0, 0);
            return;
        }
        catch (Exception exception) {
            Agent.message("bpt set failed");
            return;
        }
    }

    private boolean SetTargetBpts(boolean bl, LineNumber lineNumber) {
        int[] nArray = this.getLineTargets(lineNumber.startPC, lineNumber.endPC - lineNumber.startPC);
        boolean bl2 = false;
        if (nArray != null) {
            int n;
            int n2 = 0;
            int n3 = nArray[this.JMP_TARGET_CT];
            while (n3 > 0) {
                if (lineNumber.line_number == this.pc2lineno(lineNumber.clazz, n = nArray[this.TARGET_LIST + n2++])) {
                    LineNumber lineNumber2 = this.getnextlinepc(lineNumber.thread, n);
                    this.SetTargetBpts(false, lineNumber2);
                    this.SetTargetBpt(lineNumber2.clazz, lineNumber2.endPC, 2);
                } else {
                    this.SetTargetBpt(lineNumber.clazz, n, 2);
                }
                --n3;
            }
            n3 = nArray[this.RET_TARGET_CT];
            while (n3 > 0) {
                if (lineNumber.startPC == (n = nArray[this.TARGET_LIST + n2++]) && !bl2) {
                    bl2 = true;
                }
                this.SetTargetBpt(lineNumber.clazz, n, 4);
                --n3;
            }
            if (bl) {
                n3 = nArray[this.CALL_TARGET_CT];
                while (n3 > 0) {
                    this.SetTargetBpt(lineNumber.clazz, nArray[this.TARGET_LIST + n2++], 4);
                    --n3;
                }
            }
        }
        return bl2;
    }

    private boolean IsMethodCall(LineNumber lineNumber) {
        int[] nArray = this.getLineTargets(lineNumber.startPC, lineNumber.endPC - lineNumber.startPC);
        return nArray != null && nArray[this.CALL_TARGET_CT] != 0;
    }

    private void stepThread(Thread thread, boolean bl) {
        if (!Agent.systemThread(thread)) {
            Agent.message("stepping " + thread.getName());
            try {
                if (bl) {
                    LineNumber lineNumber = this.getnextlinepc(thread, 0);
                    this.inInterpStep = false;
                    this.setSingleStep(thread, false);
                    if (lineNumber != null && !this.IsMethodCall(lineNumber)) {
                        this.stepNextThread(thread);
                        return;
                    }
                    StackFrame stackFrame = this.getStackFrame(thread, 0);
                    lineNumber = this.lineno2pc(stackFrame.clazz, stackFrame.lineno);
                    if (lineNumber != null) {
                        lineNumber.thread = thread;
                        this.bkptHandler.addSkipLine(lineNumber);
                    }
                }
                this.inInterpStep = true;
                this.setSingleStep(thread, true);
                this.resumeLastSuspendedThreads();
                SymDbgNotify.notifyInterpDebug(3);
                return;
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                Agent.error("step failed: " + illegalThreadStateException.getMessage());
                return;
            }
        }
    }

    private void SetExceptionTargetBpt(LineNumber lineNumber) {
        int n = this.GetExceptionTarget(lineNumber.clazz, lineNumber.endPC);
        if (n != 0) {
            this.SetTargetBpt(lineNumber.clazz, n, 2);
        }
    }

    private void stepNextThread(Thread thread) {
        if (!Agent.systemThread(thread)) {
            Agent.message("next stepping " + thread.getName());
            try {
                LineNumber lineNumber = this.getnextlinepc(thread, 0);
                if (lineNumber == null) {
                    Agent.message("no line information available, single-stepping.");
                    this.stepThread(thread, false);
                    return;
                }
                boolean bl = this.SetTargetBpts(false, lineNumber);
                this.SetExceptionTargetBpt(lineNumber);
                try {
                    this.bkptHandler.addBreakpoint(lineNumber.clazz, lineNumber.endPC, 2, 0, 0);
                }
                catch (Exception exception) {
                    Agent.message("next-step failed: " + exception.toString() + ", single-stepping.");
                    this.stepThread(thread, false);
                    return;
                }
                if (bl) {
                    this.stepThread(thread, false);
                    return;
                }
                this.resumeLastSuspendedThreads();
                SymDbgNotify.notifyInterpDebug(3);
                return;
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                Agent.error("next step failed: " + illegalThreadStateException.getMessage());
                return;
            }
        }
    }

    private void singleStepThread(Thread thread, boolean bl) {
        if (!Agent.systemThread(thread)) {
            Agent.message("source single stepping " + thread.getName());
            try {
                LineNumber lineNumber = this.getnextlinepc(thread, 0);
                if (lineNumber == null) {
                    Agent.message("no line information available, single-stepping.");
                    this.stepThread(thread, false);
                    return;
                }
                boolean bl2 = this.SetTargetBpts(true, lineNumber);
                this.SetExceptionTargetBpt(lineNumber);
                try {
                    this.bkptHandler.addBreakpoint(lineNumber.clazz, lineNumber.endPC, 2, 0, 0);
                }
                catch (Exception exception) {
                    Agent.message("source single-step failed: " + exception.toString() + ", single-stepping.");
                    this.stepThread(thread, false);
                    return;
                }
                if (bl2) {
                    this.stepThread(thread, false);
                    return;
                }
                StackFrame stackFrame = this.getStackFrame(thread, 0);
                lineNumber = this.lineno2pc(stackFrame.clazz, stackFrame.lineno);
                if (lineNumber != null) {
                    lineNumber.thread = thread;
                    this.bkptHandler.addSkipLine(lineNumber);
                }
                this.inInterpStep = false;
                this.setSingleStep(thread, false);
                this.resumeLastSuspendedThreads();
                SymDbgNotify.notifyInterpDebug(3);
                return;
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                Agent.error("source single-step failed: " + illegalThreadStateException.getMessage());
                return;
            }
        }
    }

    private void stepOutThread(Thread thread) {
        if (!Agent.systemThread(thread)) {
            Agent.message("return stepping " + thread.getName());
            try {
                LineNumber lineNumber = this.GetReturnTarget(thread, 1);
                if (lineNumber == null) {
                    Agent.message("no line information available, single-stepping.");
                    this.stepThread(thread, false);
                    return;
                }
                try {
                    this.bkptHandler.addBreakpoint(lineNumber.clazz, lineNumber.endPC, 2, 0, 0);
                }
                catch (Exception exception) {
                    Agent.message("return-step failed: " + exception.toString() + ", single-stepping.");
                    this.stepThread(thread, false);
                    return;
                }
                this.resumeLastSuspendedThreads();
                SymDbgNotify.notifyInterpDebug(3);
                return;
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                Agent.error("return step failed: " + illegalThreadStateException.getMessage());
                return;
            }
        }
    }

    private void stepPopThread(Thread thread) {
        if (!Agent.systemThread(thread)) {
            Agent.message("pop stepping " + thread.getName());
            this.setupPopThread(thread);
            this.resumeLastSuspendedThreads();
            SymDbgNotify.notifyInterpDebug(3);
        }
    }

    void suspendAllThreads() {
        Agent.message("suspendAllThreads()");
        ThreadList threadList = new ThreadList();
        int n = 0;
        while (n < threadList.count) {
            this.suspendThread(threadList.threads[n]);
            ++n;
        }
        this.lastSuspended = threadList;
    }

    private void resumeThread(Thread thread) {
        if (!Agent.systemThread(thread)) {
            Agent.message("resuming " + thread.getName());
            try {
                this.resumeThreadOnce(thread);
                return;
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                Agent.error("resume failed: " + illegalThreadStateException.getMessage());
                return;
            }
        }
    }

    void resumeLastSuspendedThreads() {
        ThreadList threadList = new ThreadList();
        this.lastSuspended = null;
        if (threadList == null) {
            Agent.message("no last suspended to resume");
            return;
        }
        Agent.message("resumeLastSuspendedThreads()");
        int n = 0;
        while (n < threadList.count) {
            this.resumeThread(threadList.threads[n]);
            ++n;
        }
    }

    native int getThreadStatus(Thread var1);

    native StackFrame getStackFrame(Thread var1, int var2);

    native Field[] getMethods(Class var1);

    native Field[] getFields(Class var1);

    native Class[] getClasses();

    native Object getSlotObject(Object var1, int var2);

    native int[] getSlotSignature(Class var1, int var2);

    native boolean getSlotBoolean(Object var1, int var2);

    native int getSlotInt(Object var1, int var2);

    native long getSlotLong(Object var1, int var2);

    native double getSlotDouble(Object var1, int var2);

    native Object[] getSlotArray(Object var1, int var2);

    native Object getStackObject(Thread var1, int var2, int var3);

    native boolean getStackBoolean(Thread var1, int var2, int var3);

    native int getStackInt(Thread var1, int var2, int var3);

    native long getStackLong(Thread var1, int var2, int var3);

    native float getStackFloat(Thread var1, int var2, int var3);

    native double getStackDouble(Thread var1, int var2, int var3);

    native Object[] getStackArray(Thread var1, int var2, int var3);

    native LineNumber lineno2pc(Class var1, int var2);

    native int pc2lineno(Class var1, int var2);

    native int method2pc(Class var1, int var2);

    native String exceptionStackTrace(Throwable var1);

    native void setSingleStep(Thread var1, boolean var2);

    native void initAgent();

    native String getClassSourceName(Class var1);

    native int[] getLinenumbers(Class var1);

    native int getMethodLinenumber(Class var1, int var2);

    native int[] getLineTargets(int var1, int var2);

    native LineNumber getnextlinepc(Thread var1, int var2);

    native void setDebugBreak();

    native int GetExceptionTarget(Class var1, int var2);

    native LineNumber GetReturnTarget(Thread var1, int var2);

    native SymDbgLoadExpr loadExprClass(byte[] var1, int var2);

    native SymDbgExprFindContext getExprContextLines(int var1);

    native int reloadMethod(String var1, String var2, String var3, byte[] var4, int var5);

    native Object getExprResultObject(Thread var1);

    native boolean getExprResultBoolean(Thread var1);

    native int getExprResultInt(Thread var1);

    native long getExprResultLong(Thread var1);

    native float getExprResultFloat(Thread var1);

    native double getExprResultDouble(Thread var1);

    native Object[] getExprResultArray(Thread var1);

    native Object[] recastObjectArray(Object var1);

    native void resumeThreadOnce(Thread var1);

    native void setupPopThread(Thread var1);

    native void setSlotBoolean(Object var1, int var2, boolean var3);

    native void setSlotInt(Object var1, int var2, int var3);

    native void setSlotLong(Object var1, int var2, long var3);

    native void setSlotDouble(Object var1, int var2, double var3);

    native void setStackBoolean(Thread var1, int var2, int var3, boolean var4);

    native void setStackInt(Thread var1, int var2, int var3, int var4);

    native void setStackLong(Thread var1, int var2, int var3, long var4);

    native void setStackDouble(Thread var1, int var2, int var3, double var4);

    synchronized void handle(int n, DataInputStream dataInputStream, DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(n);
        SecurityManager.enablePrivilege((String)"UniversalThreadAccess");
        SecurityManager.enablePrivilege((String)"UniversalThreadGroupAccess");
        switch (n) {
            case 49: {
                Class[] classArray = this.getClasses();
                dataOutputStream.writeInt(classArray.length);
                int n2 = 0;
                while (n2 < classArray.length) {
                    this.writeObject(classArray[n2]);
                    ++n2;
                }
                return;
            }
            case 20: {
                Class clazz = (Class)this.objects.get(new Integer(dataInputStream.readInt()));
                dataOutputStream.writeUTF(clazz.getName());
                dataOutputStream.writeUTF(this.getClassSourceName(clazz));
                dataOutputStream.writeInt(clazz.isInterface() ? 1 : 0);
                this.writeObject(clazz.getSuperclass());
                this.writeObject(clazz.getClassLoader());
                Class<?>[] classArray = clazz.getInterfaces();
                dataOutputStream.writeInt(classArray.length);
                int n3 = 0;
                while (n3 < classArray.length) {
                    this.writeObject(classArray[n3]);
                    ++n3;
                }
                return;
            }
            case 21: {
                dataOutputStream.writeUTF(((Thread)this.objects.get(new Integer(dataInputStream.readInt()))).getName());
                return;
            }
            case 22: {
                String string = dataInputStream.readUTF();
                try {
                    this.writeObject(Class.forName(string));
                    return;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    Agent.message("no such class: " + string);
                    this.writeObject(null);
                    return;
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    Agent.message("no such class: " + string);
                    this.writeObject(null);
                    return;
                }
                catch (ExceptionInInitializerError exceptionInInitializerError) {
                    Agent.message("exception initializing: " + string);
                    this.writeObject(null);
                    return;
                }
            }
            case 31: {
                dataOutputStream.writeInt(this.getThreadStatus((Thread)this.objects.get(new Integer(dataInputStream.readInt()))));
                return;
            }
            case 32: {
                Thread thread = (Thread)this.objects.get(new Integer(dataInputStream.readInt()));
                int n4 = thread.countStackFrames();
                dataOutputStream.writeInt(n4);
                int n5 = 0;
                while (n5 < n4) {
                    StackFrame stackFrame = this.getStackFrame(thread, n5);
                    this.writeObject(stackFrame);
                    dataOutputStream.writeUTF(stackFrame.className);
                    dataOutputStream.writeUTF(stackFrame.methodName);
                    dataOutputStream.writeInt(stackFrame.lineno);
                    dataOutputStream.writeInt(stackFrame.pc);
                    this.writeObject(stackFrame.clazz);
                    dataOutputStream.writeInt(stackFrame.localVariables.length);
                    int n6 = 0;
                    while (n6 < stackFrame.localVariables.length) {
                        Agent.message("lvar " + n6 + ": slot=" + stackFrame.localVariables[n6].slot + ", name=" + stackFrame.localVariables[n6].name + ", sig=" + stackFrame.localVariables[n6].signature + ", argument=" + stackFrame.localVariables[n6].methodArgument);
                        dataOutputStream.writeInt(stackFrame.localVariables[n6].slot);
                        dataOutputStream.writeUTF(stackFrame.localVariables[n6].name);
                        dataOutputStream.writeUTF(stackFrame.localVariables[n6].signature);
                        dataOutputStream.writeBoolean(stackFrame.localVariables[n6].methodArgument);
                        ++n6;
                    }
                    ++n5;
                }
                return;
            }
            case 50: {
                Thread thread = (Thread)this.objects.get(new Integer(dataInputStream.readInt()));
                int n7 = dataInputStream.readInt();
                int n8 = dataInputStream.readInt();
                char c = dataInputStream.readChar();
                switch (c) {
                    case 'Z': {
                        this.write(this.getStackBoolean(thread, n7, n8));
                        return;
                    }
                    case 'B': {
                        this.write((byte)this.getStackInt(thread, n7, n8));
                        return;
                    }
                    case 'C': {
                        this.write((char)this.getStackInt(thread, n7, n8));
                        return;
                    }
                    case 'S': {
                        this.write((short)this.getStackInt(thread, n7, n8));
                        return;
                    }
                    case 'I': {
                        this.write(this.getStackInt(thread, n7, n8));
                        return;
                    }
                    case 'J': {
                        this.write(this.getStackLong(thread, n7, n8));
                        return;
                    }
                    case 'F': {
                        this.write(this.getStackFloat(thread, n7, n8));
                        return;
                    }
                    case 'D': {
                        this.write(this.getStackDouble(thread, n7, n8));
                        return;
                    }
                    case '[': {
                        Object[] objectArray = this.getStackArray(thread, n7, n8);
                        this.writeArray(objectArray);
                        return;
                    }
                    case 'L': {
                        this.writeObject(this.getStackObject(thread, n7, n8));
                        return;
                    }
                    case 'V': {
                        this.writeObject(null);
                        return;
                    }
                }
                String string = new String("bogus signature(" + c + ")");
                Agent.error(string);
                this.writeObject(string);
                return;
            }
            case 69: {
                Thread thread = (Thread)this.objects.get(new Integer(dataInputStream.readInt()));
                int n9 = dataInputStream.readInt();
                int n10 = dataInputStream.readInt();
                int n11 = dataInputStream.readInt();
                switch (n11) {
                    case 0: {
                        this.setStackBoolean(thread, n9, n10, dataInputStream.readBoolean());
                        return;
                    }
                    case 4: {
                        this.setStackInt(thread, n9, n10, dataInputStream.readInt());
                        return;
                    }
                    case 5: {
                        this.setStackLong(thread, n9, n10, dataInputStream.readLong());
                        return;
                    }
                    case 7: {
                        this.setStackDouble(thread, n9, n10, dataInputStream.readDouble());
                        return;
                    }
                }
                Agent.error("bogus type(" + n11 + ")");
                return;
            }
            case 23: {
                Object object;
                int n12 = dataInputStream.readInt();
                Hashtable<Integer, Object> hashtable = new Hashtable<Integer, Object>();
                int n13 = 0;
                while (n13 < n12) {
                    object = this.objects.get(new Integer(dataInputStream.readInt()));
                    if (object != null) {
                        hashtable.put(new Integer(this.objectId(object)), object);
                    }
                    ++n13;
                }
                dataOutputStream.flush();
                n = dataInputStream.read();
                dataOutputStream.writeInt(n);
                switch (n) {
                    case 24: {
                        try {
                            Object v;
                            object = new Hashtable();
                            Enumeration enumeration = this.objects.elements();
                            while (enumeration.hasMoreElements()) {
                                v = enumeration.nextElement();
                                ((Hashtable)object).put((Integer)new Integer(this.objectId(v)), v);
                            }
                            enumeration = this.objects.elements();
                            while (enumeration.hasMoreElements()) {
                                Integer n14;
                                v = enumeration.nextElement();
                                if (v instanceof Class || hashtable.get(n14 = new Integer(this.objectId(v))) != null) continue;
                                ((Hashtable)object).remove(n14);
                            }
                            this.objects = object;
                            System.gc();
                            enumeration = this.objects.elements();
                            while (enumeration.hasMoreElements()) {
                                v = enumeration.nextElement();
                                if (v == null) continue;
                                this.writeObject(v);
                            }
                            this.writeObject(null);
                        }
                        catch (Exception exception) {
                            Agent.error("CMD_MARK_OBJECTS failed: " + exception.toString());
                        }
                        break;
                    }
                    default: {
                        Agent.error("mark objects command failed");
                    }
                }
                dataOutputStream.flush();
                return;
            }
            case 47: {
                ThreadGroup[] threadGroupArray = new ThreadGroup[256];
                ThreadGroup threadGroup = (ThreadGroup)this.objects.get(new Integer(dataInputStream.readInt()));
                int n15 = 0;
                if (threadGroup == null) {
                    Agent.message("Getting all threadgroups");
                    threadGroup = Thread.currentThread().getThreadGroup();
                    n15 = threadGroup.enumerate(threadGroupArray);
                    dataOutputStream.writeInt(n15 + 1);
                    this.writeObject(threadGroup);
                } else {
                    Agent.message("Getting threadgroups for " + threadGroup.getName());
                    n15 = threadGroup.enumerate(threadGroupArray);
                    dataOutputStream.writeInt(n15);
                }
                int n16 = 0;
                while (n16 < n15) {
                    this.writeObject(threadGroupArray[n16]);
                    ++n16;
                }
                return;
            }
            case 48: {
                ThreadGroup threadGroup = (ThreadGroup)this.objects.get(new Integer(dataInputStream.readInt()));
                this.writeObject(threadGroup.getParent());
                dataOutputStream.writeUTF(threadGroup.getName());
                dataOutputStream.writeInt(threadGroup.getMaxPriority());
                dataOutputStream.writeBoolean(threadGroup.isDaemon());
                return;
            }
            case 25: {
                Thread[] threadArray = new Thread[256];
                ThreadGroup threadGroup = (ThreadGroup)this.objects.get(new Integer(dataInputStream.readInt()));
                boolean bl = dataInputStream.readBoolean();
                Agent.message("Getting threads for " + threadGroup.getName());
                int n17 = threadGroup.enumerate(threadArray, bl);
                dataOutputStream.writeInt(n17);
                int n18 = 0;
                while (n18 < n17) {
                    this.writeObject(threadArray[n18]);
                    ++n18;
                }
                return;
            }
            case 26: {
                String[] stringArray = new String[dataInputStream.read() - 1];
                String string = dataInputStream.readUTF();
                new String("");
                int n19 = 0;
                while (n19 < stringArray.length) {
                    stringArray[n19] = dataInputStream.readUTF();
                    ++n19;
                }
                try {
                    Class<?> clazz = Class.forName(string);
                    ThreadGroup threadGroup = new ThreadGroup(String.valueOf(clazz.getName()) + ".main");
                    MainThread mainThread = new MainThread(this, threadGroup, clazz, stringArray);
                    this.writeObject(mainThread.getThreadGroup());
                    Agent.beginRun();
                    return;
                }
                catch (Exception exception) {
                    Agent.message(this.exceptionStackTrace(exception));
                    this.writeObject(null);
                    return;
                }
            }
            case 27: {
                this.suspendThread((Thread)this.objects.get(new Integer(dataInputStream.readInt())));
                return;
            }
            case 28: {
                this.resumeThread((Thread)this.objects.get(new Integer(dataInputStream.readInt())));
                return;
            }
            case 29: {
                this.resumeLastSuspendedThreads();
                SymDbgNotify.notifyInterpDebugThreadResume();
                return;
            }
            case 35: {
                Class clazz = (Class)this.objects.get(new Integer(dataInputStream.readInt()));
                Field[] fieldArray = this.getFields(clazz);
                dataOutputStream.writeInt(fieldArray.length);
                int n20 = 0;
                while (n20 < fieldArray.length) {
                    dataOutputStream.writeInt(fieldArray[n20].slot);
                    dataOutputStream.writeUTF(fieldArray[n20].name);
                    dataOutputStream.writeUTF(fieldArray[n20].signature);
                    dataOutputStream.writeShort(fieldArray[n20].access);
                    this.writeObject(fieldArray[n20].clazz);
                    ++n20;
                }
                return;
            }
            case 36: {
                Class clazz = (Class)this.objects.get(new Integer(dataInputStream.readInt()));
                Field[] fieldArray = this.getMethods(clazz);
                dataOutputStream.writeInt(fieldArray.length);
                int n21 = 0;
                while (n21 < fieldArray.length) {
                    dataOutputStream.writeInt(fieldArray[n21].slot);
                    dataOutputStream.writeUTF(fieldArray[n21].name);
                    dataOutputStream.writeUTF(fieldArray[n21].signature);
                    dataOutputStream.writeShort(fieldArray[n21].access);
                    this.writeObject(fieldArray[n21].clazz);
                    ++n21;
                }
                return;
            }
            case 40: {
                Object v = this.objects.get(new Integer(dataInputStream.readInt()));
                int n22 = dataInputStream.readInt();
                int n23 = dataInputStream.readInt();
                int n24 = dataInputStream.readInt();
                dataOutputStream.writeInt(n24 - n23 + 1);
                switch (n22) {
                    case 2: {
                        char[] cArray = (char[])v;
                        int n25 = n23;
                        while (n25 <= n24) {
                            this.write(cArray[n25]);
                            ++n25;
                        }
                        return;
                    }
                    case 1: {
                        byte[] byArray = (byte[])v;
                        int n26 = n23;
                        while (n26 <= n24) {
                            this.write(byArray[n26]);
                            ++n26;
                        }
                        return;
                    }
                    case 10: 
                    case 17: {
                        Object[] objectArray = (Object[])v;
                        int n27 = n23;
                        while (n27 <= n24) {
                            this.writeObject(objectArray[n27]);
                            ++n27;
                        }
                        return;
                    }
                    case 9: {
                        Object[] objectArray = (Object[])v;
                        int n28 = n23;
                        while (n28 <= n24) {
                            this.writeArray(this.recastObjectArray(objectArray[n28]));
                            ++n28;
                        }
                        return;
                    }
                    case 6: {
                        float[] fArray = (float[])v;
                        int n29 = n23;
                        while (n29 <= n24) {
                            this.write(fArray[n29]);
                            ++n29;
                        }
                        return;
                    }
                    case 7: {
                        double[] dArray = (double[])v;
                        int n30 = n23;
                        while (n30 <= n24) {
                            this.write(dArray[n30]);
                            ++n30;
                        }
                        return;
                    }
                    case 4: {
                        int[] nArray = (int[])v;
                        int n31 = n23;
                        while (n31 <= n24) {
                            this.write(nArray[n31]);
                            ++n31;
                        }
                        return;
                    }
                    case 5: {
                        long[] lArray = (long[])v;
                        int n32 = n23;
                        while (n32 <= n24) {
                            this.write(lArray[n32]);
                            ++n32;
                        }
                        return;
                    }
                    case 3: {
                        short[] sArray = (short[])v;
                        int n33 = n23;
                        while (n33 <= n24) {
                            this.write(sArray[n33]);
                            ++n33;
                        }
                        return;
                    }
                    case 0: {
                        boolean[] blArray = (boolean[])v;
                        int n34 = n23;
                        while (n34 <= n24) {
                            this.write(blArray[n34]);
                            ++n34;
                        }
                        return;
                    }
                }
                int n35 = n23;
                while (n35 <= n24) {
                    this.writeObject(null);
                    ++n35;
                }
                return;
            }
            case 38: {
                Class clazz = (Class)this.objects.get(new Integer(dataInputStream.readInt()));
                int n36 = dataInputStream.readInt();
                int[] nArray = this.getSlotSignature(clazz, n36);
                if (nArray == null) {
                    dataOutputStream.writeInt(0);
                    return;
                }
                dataOutputStream.writeInt(nArray.length);
                int n37 = 0;
                while (n37 < nArray.length) {
                    dataOutputStream.writeInt(nArray[n37]);
                    ++n37;
                }
                return;
            }
            case 39: {
                Object v = this.objects.get(new Integer(dataInputStream.readInt()));
                int n38 = dataInputStream.readInt();
                int[] nArray = this.getSlotSignature(v instanceof Class ? (Class<?>)v : v.getClass(), n38);
                if (nArray == null) {
                    this.writeObject(new ArrayIndexOutOfBoundsException("invalid slot index " + n38));
                    return;
                }
                switch (nArray[0]) {
                    case 0: {
                        this.write(this.getSlotBoolean(v, n38));
                        return;
                    }
                    case 1: {
                        this.write((byte)this.getSlotInt(v, n38));
                        return;
                    }
                    case 2: {
                        this.write((char)this.getSlotInt(v, n38));
                        return;
                    }
                    case 3: {
                        this.write((short)this.getSlotInt(v, n38));
                        return;
                    }
                    case 4: {
                        this.write(this.getSlotInt(v, n38));
                        return;
                    }
                    case 5: {
                        this.write(this.getSlotLong(v, n38));
                        return;
                    }
                    case 6: {
                        this.write((float)this.getSlotDouble(v, n38));
                        return;
                    }
                    case 7: {
                        this.write(this.getSlotDouble(v, n38));
                        return;
                    }
                    case 9: {
                        Object[] objectArray = this.getSlotArray(v, n38);
                        this.writeArray(objectArray);
                        return;
                    }
                    case 16: 
                    case 17: {
                        Object object = this.getSlotObject(v, n38);
                        this.writeObject(object);
                        return;
                    }
                    case 11: {
                        this.writeObject(null);
                        return;
                    }
                }
                String string = new String("bogus signature(");
                int n39 = 0;
                while (n39 < nArray.length) {
                    string = string.concat(" " + new Integer(nArray[n39]).toString());
                    ++n39;
                }
                string = string.concat(" )");
                Agent.error(string);
                this.writeObject(string);
            }
            case 68: {
                Object v = this.objects.get(new Integer(dataInputStream.readInt()));
                int n38 = dataInputStream.readInt();
                int n40 = dataInputStream.readInt();
                switch (n40) {
                    case 0: {
                        this.setSlotBoolean(v, n38, dataInputStream.readBoolean());
                        return;
                    }
                    case 4: {
                        this.setSlotInt(v, n38, dataInputStream.readInt());
                        return;
                    }
                    case 5: {
                        this.setSlotLong(v, n38, dataInputStream.readLong());
                        return;
                    }
                    case 7: {
                        this.setSlotDouble(v, n38, dataInputStream.readDouble());
                        return;
                    }
                }
                Agent.error("bogus type(" + n40 + ")");
                return;
            }
            case 41: {
                Class clazz = (Class)this.objects.get(new Integer(dataInputStream.readInt()));
                int n41 = dataInputStream.readInt();
                LineNumber lineNumber = this.lineno2pc(clazz, n41);
                String string = "";
                if (lineNumber == null) {
                    string = "No code at line " + n41 + ", source file has not been parsed completely" + ", or class is optimized.";
                } else {
                    try {
                        this.bkptHandler.addBreakpoint(clazz, lineNumber.startPC, 1, 0, 0);
                    }
                    catch (Exception exception) {
                        Agent.message(this.exceptionStackTrace(exception));
                        string = exception.toString();
                    }
                }
                dataOutputStream.writeUTF(string);
                return;
            }
            case 81: {
                Class clazz = (Class)this.objects.get(new Integer(dataInputStream.readInt()));
                int n42 = dataInputStream.readInt();
                int n43 = dataInputStream.readInt();
                int n44 = dataInputStream.readInt();
                LineNumber lineNumber = this.lineno2pc(clazz, n42);
                String string = "";
                if (lineNumber == null) {
                    string = "No code at line " + n42 + ", source file has not been parsed completely" + ", or class is optimized.";
                } else {
                    try {
                        this.bkptHandler.addBreakpoint(clazz, lineNumber.startPC, 8, n43, n44);
                    }
                    catch (Exception exception) {
                        Agent.message(this.exceptionStackTrace(exception));
                        string = exception.toString();
                    }
                }
                dataOutputStream.writeUTF(string);
                return;
            }
            case 82: {
                Class clazz = (Class)this.objects.get(new Integer(dataInputStream.readInt()));
                int n45 = dataInputStream.readInt();
                LineNumber lineNumber = this.lineno2pc(clazz, n45);
                if (lineNumber == null) {
                    dataOutputStream.writeInt(1);
                    return;
                }
                try {
                    int n46 = this.bkptHandler.getCondBptCurCount(clazz, lineNumber.startPC);
                    dataOutputStream.writeInt(0);
                    dataOutputStream.writeInt(n46);
                    return;
                }
                catch (InvalidPCException invalidPCException) {
                    dataOutputStream.writeInt(1);
                    return;
                }
            }
            case 42: {
                Class clazz = (Class)this.objects.get(new Integer(dataInputStream.readInt()));
                int n47 = dataInputStream.readInt();
                int n48 = this.method2pc(clazz, n47);
                Agent.message("method2pc(" + clazz.getName() + "," + n47 + ") = " + n48);
                String string = "";
                if (n48 == -1) {
                    string = "Not a Java method";
                } else {
                    try {
                        this.bkptHandler.addBreakpoint(clazz, n48, 1, 0, 0);
                    }
                    catch (Exception exception) {
                        Agent.message(this.exceptionStackTrace(exception));
                        string = exception.toString();
                    }
                }
                dataOutputStream.writeUTF(string);
                return;
            }
            case 65: {
                BreakpointSet[] breakpointSetArray = this.bkptHandler.listBreakpoints();
                dataOutputStream.writeInt(breakpointSetArray.length);
                int n49 = 0;
                while (n49 < breakpointSetArray.length) {
                    dataOutputStream.writeUTF(String.valueOf(breakpointSetArray[n49].clazz.getName()) + ":" + this.pc2lineno(breakpointSetArray[n49].clazz, breakpointSetArray[n49].pc));
                    ++n49;
                }
                return;
            }
            case 43: {
                Class clazz = (Class)this.objects.get(new Integer(dataInputStream.readInt()));
                int n50 = dataInputStream.readInt();
                Agent.message("clearing bkpt at " + clazz.getName() + ":" + n50);
                String string = "";
                if (n50 == -1) {
                    string = "No code at pc " + n50;
                } else {
                    try {
                        this.bkptHandler.deleteBreakpoint(clazz, n50);
                    }
                    catch (Exception exception) {
                        Agent.message(this.exceptionStackTrace(exception));
                        string = exception.toString();
                    }
                }
                dataOutputStream.writeUTF(string);
                return;
            }
            case 44: {
                Class clazz = (Class)this.objects.get(new Integer(dataInputStream.readInt()));
                int n51 = dataInputStream.readInt();
                Agent.message("clearing bkpt at " + clazz.getName() + ":" + n51);
                LineNumber lineNumber = this.lineno2pc(clazz, n51);
                String string = "";
                if (lineNumber == null) {
                    string = "No code at line " + n51 + ", or class is optimized.";
                } else {
                    try {
                        this.bkptHandler.deleteBreakpoint(clazz, lineNumber.startPC);
                    }
                    catch (Exception exception) {
                        Agent.message(this.exceptionStackTrace(exception));
                        string = exception.toString();
                    }
                }
                dataOutputStream.writeUTF(string);
                return;
            }
            case 45: {
                Class clazz = (Class)this.objects.get(new Integer(dataInputStream.readInt()));
                int n52 = dataInputStream.readInt();
                Agent.message("clearing bkpt at " + clazz.getName());
                int n53 = this.method2pc(clazz, n52);
                String string = "";
                if (n53 == -1) {
                    string = "Not a Java method";
                } else {
                    try {
                        this.bkptHandler.deleteBreakpoint(clazz, n53);
                    }
                    catch (Exception exception) {
                        Agent.message(this.exceptionStackTrace(exception));
                        string = exception.toString();
                    }
                }
                dataOutputStream.writeUTF(string);
                return;
            }
            case 53: {
                try {
                    Class clazz = (Class)this.objects.get(new Integer(dataInputStream.readInt()));
                    this.bkptHandler.catchExceptionClass(clazz);
                    return;
                }
                catch (Exception exception) {
                    Agent.error("catchExceptionClass failed: " + exception);
                    return;
                }
            }
            case 54: {
                try {
                    Class clazz = (Class)this.objects.get(new Integer(dataInputStream.readInt()));
                    this.bkptHandler.ignoreExceptionClass(clazz);
                    return;
                }
                catch (Exception exception) {
                    Agent.error("ignoreExceptionClass failed: " + exception);
                    return;
                }
            }
            case 55: {
                Class[] classArray = this.bkptHandler.getCatchList();
                dataOutputStream.writeInt(classArray.length);
                int n54 = 0;
                while (n54 < classArray.length) {
                    this.writeObject(classArray[n54]);
                    ++n54;
                }
                return;
            }
            case 56: {
                Thread thread = (Thread)this.objects.get(new Integer(dataInputStream.readInt()));
                thread.stop();
                Agent.message(String.valueOf(thread.getName()) + " stopped.");
                return;
            }
            case 57: {
                ThreadGroup threadGroup = (ThreadGroup)this.objects.get(new Integer(dataInputStream.readInt()));
                threadGroup.stop();
                Agent.message(String.valueOf(threadGroup.getName()) + " stopped.");
                return;
            }
            case 51: {
                verbose = dataInputStream.readBoolean();
                return;
            }
            case 78: {
                this.setDebugBreak();
                return;
            }
            case 34: {
                switch (dataInputStream.readInt()) {
                    case 2: {
                        dataOutputStream.writeInt((int)Runtime.getRuntime().freeMemory());
                        return;
                    }
                    case 1: {
                        dataOutputStream.writeInt((int)Runtime.getRuntime().totalMemory());
                        return;
                    }
                    case 3: {
                        Runtime.getRuntime().traceMethodCalls(dataInputStream.readInt() != 0);
                        return;
                    }
                    case 4: {
                        Runtime.getRuntime().traceInstructions(dataInputStream.readInt() != 0);
                        return;
                    }
                }
                return;
            }
            case 59: {
                String string = dataInputStream.readUTF();
                String string2 = dataInputStream.readUTF();
                int n55 = string2.lastIndexOf(46);
                String string3 = n55 >= 0 ? string2.substring(0, n55) : "";
                Package package_ = null;
                try {
                    package_ = new Package(this.sourcePath, Identifier.lookup(string3));
                }
                catch (Exception exception) {
                    Agent.message("cannot create a Package for " + string3);
                    dataOutputStream.writeInt(-1);
                    return;
                }
                ClassFile classFile = null;
                InputStream inputStream = null;
                try {
                    classFile = package_.getSourceFile(string);
                    if (classFile == null) {
                        Agent.message("no source " + string);
                        dataOutputStream.writeInt(-1);
                        return;
                    }
                    inputStream = classFile.getInputStream();
                }
                catch (Exception exception) {
                    Agent.message("cannot find " + string);
                    dataOutputStream.writeInt(-1);
                    return;
                }
                int n56 = (int)classFile.length();
                dataOutputStream.writeInt(n56);
                byte[] byArray = new byte[n56];
                try {
                    int n57 = 0;
                    int n58 = byArray.length;
                    while (n58 > 0) {
                        int n59 = inputStream.read(byArray, n57, n58);
                        if (n59 == -1) {
                            throw new IOException();
                        }
                        n57 += n59;
                        n58 -= n59;
                    }
                    dataOutputStream.write(byArray);
                }
                catch (IOException iOException) {
                    Agent.error("unable to read " + string);
                    return;
                }
                inputStream.close();
                return;
            }
            case 60: {
                Object v = this.objects.get(new Integer(dataInputStream.readInt()));
                String string = "";
                try {
                    string = v.toString();
                    dataOutputStream.writeInt(1);
                    dataOutputStream.writeUTF(string);
                    return;
                }
                catch (Exception exception) {
                    dataOutputStream.writeInt(0);
                    return;
                }
            }
            case 61: {
                dataOutputStream.writeUTF(this.sourcePath.toString());
                return;
            }
            case 62: {
                String string = dataInputStream.readUTF();
                if (string == null) {
                    string = ".";
                }
                this.sourcePath = new ClassPath(string);
                return;
            }
            case 63: {
                this.singleStepThread((Thread)this.objects.get(new Integer(dataInputStream.readInt())), dataInputStream.readBoolean());
                return;
            }
            case 64: {
                this.stepNextThread((Thread)this.objects.get(new Integer(dataInputStream.readInt())));
                return;
            }
            case 77: {
                this.stepOutThread((Thread)this.objects.get(new Integer(dataInputStream.readInt())));
                return;
            }
            case 86: {
                this.stepPopThread((Thread)this.objects.get(new Integer(dataInputStream.readInt())));
                return;
            }
            case 70: {
                this.objects.remove(new Integer(dataInputStream.readInt()));
                return;
            }
            case 71: {
                Class clazz = (Class)this.objects.get(new Integer(dataInputStream.readInt()));
                int[] nArray = this.getLinenumbers(clazz);
                int n60 = nArray.length;
                dataOutputStream.writeInt(n60);
                int n61 = 0;
                while (n61 < n60) {
                    dataOutputStream.writeInt(nArray[n61]);
                    ++n61;
                }
                return;
            }
            case 72: {
                Class clazz = (Class)this.objects.get(new Integer(dataInputStream.readInt()));
                int n62 = dataInputStream.readInt();
                dataOutputStream.writeInt(this.getMethodLinenumber(clazz, n62));
                return;
            }
            case 79: {
                int n63 = dataInputStream.readInt();
                byte[] byArray = new byte[n63];
                int n64 = dataInputStream.readInt();
                int n65 = n63 / n64;
                int n66 = n63 % n64;
                dataOutputStream.flush();
                n = dataInputStream.read();
                int n67 = 0;
                while (n67 < n65) {
                    dataInputStream.readFully(byArray, n67 * n64, n64);
                    dataOutputStream.writeInt(n);
                    dataOutputStream.flush();
                    n = dataInputStream.read();
                    ++n67;
                }
                dataInputStream.readFully(byArray, n65 * n64, n66);
                dataOutputStream.writeInt(n);
                dataOutputStream.flush();
                SymDbgLoadExpr symDbgLoadExpr = this.loadExprClass(byArray, n63);
                dataOutputStream.writeInt(symDbgLoadExpr.status);
                if (symDbgLoadExpr.status == 0) {
                    dataOutputStream.writeInt(symDbgLoadExpr.pc);
                    dataOutputStream.writeUTF(symDbgLoadExpr.sig);
                    this.exprHandler.addExpression(symDbgLoadExpr.pc, symDbgLoadExpr.sig);
                }
                return;
            }
            case 80: {
                Thread thread = (Thread)this.objects.get(new Integer(dataInputStream.readInt()));
                int n68 = dataInputStream.readInt();
                String string = this.exprHandler.getSignature(n68);
                if (string == null) {
                    dataOutputStream.writeInt(1);
                    this.writeObject(null);
                    return;
                }
                Throwable throwable = SymDbgExprHandler.evaluate(thread, n68, false);
                if (throwable == null) {
                    dataOutputStream.writeInt(0);
                    switch (string.charAt(0)) {
                        case 'Z': {
                            this.write(this.getExprResultBoolean(thread));
                            return;
                        }
                        case 'B': {
                            this.write((byte)this.getExprResultInt(thread));
                            return;
                        }
                        case 'C': {
                            this.write((char)this.getExprResultInt(thread));
                            return;
                        }
                        case 'S': {
                            this.write((short)this.getExprResultInt(thread));
                            return;
                        }
                        case 'I': {
                            this.write(this.getExprResultInt(thread));
                            return;
                        }
                        case 'J': {
                            this.write(this.getExprResultLong(thread));
                            return;
                        }
                        case 'F': {
                            this.write(this.getExprResultFloat(thread));
                            return;
                        }
                        case 'D': {
                            this.write(this.getExprResultDouble(thread));
                            return;
                        }
                        case '[': {
                            Object[] objectArray = this.getExprResultArray(thread);
                            this.writeArray(objectArray);
                            return;
                        }
                        case 'L': {
                            this.writeObject(this.getExprResultObject(thread));
                            return;
                        }
                        case 'V': {
                            this.writeObject(null);
                            return;
                        }
                        case '*': {
                            this.write(0);
                            return;
                        }
                    }
                    String string4 = new String("bogus signature(" + string.charAt(0) + ")");
                    Agent.error(string4);
                    this.writeObject(string4);
                    return;
                }
                dataOutputStream.writeInt(2);
                this.writeObject(new String(throwable.toString()));
                return;
            }
            case 84: {
                SymDbgExprFindContext symDbgExprFindContext = this.getExprContextLines(dataInputStream.readInt());
                if (symDbgExprFindContext != null) {
                    dataOutputStream.writeInt(symDbgExprFindContext.status);
                    dataOutputStream.writeInt(symDbgExprFindContext.start);
                    dataOutputStream.writeInt(symDbgExprFindContext.end);
                    return;
                }
                dataOutputStream.writeInt(-1);
                return;
            }
            case 85: {
                String string = dataInputStream.readUTF();
                String string5 = dataInputStream.readInt() == 1 ? dataInputStream.readUTF() : null;
                String string6 = dataInputStream.readInt() == 1 ? dataInputStream.readUTF() : null;
                int n69 = dataInputStream.readInt();
                byte[] byArray = new byte[n69];
                dataInputStream.readFully(byArray);
                dataOutputStream.writeInt(this.reloadMethod(string, string5, string6, byArray, n69));
                return;
            }
            case 58: {
                this.keepRunning = false;
                return;
            }
        }
        Agent.error("command not understood: " + n);
    }

    native int objectId(Object var1);

    native void runMain(Class var1, String[] var2);

    void writeObject(Object object, DataOutputStream dataOutputStream) throws IOException {
        int n = 0;
        if (object == null) {
            dataOutputStream.writeInt(17);
        } else if (object instanceof Class) {
            dataOutputStream.writeInt(16);
            n = this.objectId(object);
            this.objects.put(new Integer(n), object);
        } else if (object instanceof String) {
            dataOutputStream.writeInt(18);
            n = this.objectId(object);
            this.objects.put(new Integer(n), object);
        } else {
            if (object instanceof Thread) {
                dataOutputStream.writeInt(19);
            } else if (object instanceof ThreadGroup) {
                dataOutputStream.writeInt(15);
            } else {
                dataOutputStream.writeInt(17);
            }
            Class<?> clazz = object.getClass();
            n = this.objectId(clazz);
            this.objects.put(new Integer(n), clazz);
            dataOutputStream.writeInt(n);
            n = this.objectId(object);
            this.objects.put(new Integer(n), object);
        }
        dataOutputStream.writeInt(n);
    }

    void writeObject(Object object) throws IOException {
        this.writeObject(object, this.out);
    }

    void writeArray(Object[] objectArray) throws IOException {
        int n = 0;
        this.out.writeInt(9);
        if (objectArray == null) {
            this.out.writeInt(0);
            return;
        }
        Class<?> clazz = objectArray.getClass();
        n = this.objectId(clazz);
        this.objects.put(new Integer(n), clazz);
        this.out.writeInt(n);
        n = this.objectId(objectArray);
        this.objects.put(new Integer(n), objectArray);
        this.out.writeInt(n);
        this.out.writeInt(objectArray.length);
    }

    void write(boolean bl) throws IOException {
        this.out.writeInt(0);
        this.out.writeBoolean(bl);
    }

    void write(byte by) throws IOException {
        this.out.writeInt(1);
        this.out.writeByte(by);
    }

    void write(char c) throws IOException {
        this.out.writeInt(2);
        this.out.writeChar(c);
    }

    void write(short s) throws IOException {
        this.out.writeInt(3);
        this.out.writeShort(s);
    }

    void write(int n) throws IOException {
        this.out.writeInt(4);
        this.out.writeInt(n);
    }

    void write(long l) throws IOException {
        this.out.writeInt(5);
        this.out.writeLong(l);
    }

    void write(float f) throws IOException {
        this.out.writeInt(6);
        this.out.writeFloat(f);
    }

    void write(double d) throws IOException {
        this.out.writeInt(7);
        this.out.writeDouble(d);
    }

    void reportAppExit() throws IOException {
        Agent.message("report application exit");
        DataOutputStream dataOutputStream = this.asyncOutputStream;
        synchronized (dataOutputStream) {
            this.asyncOutputStream.write(67);
            this.asyncOutputStream.flush();
            return;
        }
    }

    static void error(String string) {
        System.out.println("[Internal error: " + string + "]");
    }

    static void message(String string) {
        if (verbose) {
            System.out.println("[debugger: " + string + "]");
        }
    }

    public static void boot(int n) {
        Object object = lock;
        synchronized (object) {
            if (agentPassword == 0) {
                DebugManager debugManager = Debugger.getDebugManager();
                if (debugManager != null) {
                    try {
                        lock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                        Object var2_6 = null;
                        return;
                    }
                    debugManager = Debugger.getDebugManager();
                }
                try {
                    SecurityManager.enablePrivilege((String)"Debugger");
                    Compiler.disable();
                    Agent agent = new Agent(n);
                    Thread thread = new Thread(agent);
                    SecurityManager.enablePrivilege((String)"UniversalThreadAccess");
                    thread.setDaemon(true);
                    thread.setName("Debugger agent");
                    thread.start();
                    Debugger.setDebugManager((DebugManager)agent);
                }
                catch (SecurityException securityException) {
                    securityException.printStackTrace();
                    Agent.debugAgentReady(0);
                    Object var2_7 = null;
                    return;
                }
            }
            return;
        }
    }

    public void debugBreak() {
        this.setDebugBreak();
    }

    public void uncaughtException(Thread thread, Throwable throwable) {
        System.out.println("### need to handle uncaughtException: " + throwable);
    }

    static {
        runBegunLock = new Object();
        lock = new Object();
    }
}

